"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_cluster_identifier: str,
    engine: str,
    availability_zones: List = None,
    backup_retention_period: int = None,
    character_set_name: str = None,
    copy_tags_to_snapshot: bool = None,
    database_name: str = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    db_subnet_group_name: str = None,
    engine_version: str = None,
    port: int = None,
    master_username: str = None,
    master_user_password: str = None,
    option_group_name: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    replication_source_identifier: str = None,
    tags: List = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    pre_signed_url: str = None,
    enable_iam_database_authentication: bool = None,
    enable_cloudwatch_logs_exports: List = None,
    deletion_protection: bool = None,
    source_region: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon Neptune DB cluster. You can use the ReplicationSourceIdentifier parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance. Note that when you create a new cluster using CreateDBCluster directly, deletion protection is disabled by default (when you create a new production cluster in the console, deletion protection is enabled by default). You can only delete a DB cluster if its DeletionProtection field is set to false.

    Args:
        availability_zones(List, optional): A list of EC2 Availability Zones that instances in the DB cluster can be created in. Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35  . Defaults to None.
        character_set_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        copy_tags_to_snapshot(bool, optional):  If set to true, tags are copied to any snapshot of the DB cluster that is created. . Defaults to None.
        database_name(str, optional): The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating. Defaults to None.
        db_cluster_identifier(str): The DB cluster identifier. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: my-cluster1 .
        db_cluster_parameter_group_name(str, optional):  The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used. Constraints:   If supplied, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to associate with this DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): A DB subnet group to associate with this DB cluster. Constraints: Must match the name of an existing DBSubnetGroup. Must not be default. Example: mySubnetgroup . Defaults to None.
        engine(str): The name of the database engine to be used for this DB cluster. Valid Values: neptune .
        engine_version(str, optional): The version number of the database engine to use for the new DB cluster. Example: 1.0.2.1 . Defaults to None.
        port(int, optional): The port number on which the instances in the DB cluster accept connections.  Default: 8182 . Defaults to None.
        master_username(str, optional): Not supported by Neptune. Defaults to None.
        master_user_password(str, optional): Not supported by Neptune. Defaults to None.
        option_group_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see  Adjusting the Preferred Maintenance Window in the Amazon Neptune User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see  Adjusting the Preferred Maintenance Window in the Amazon Neptune User Guide.  Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        replication_source_identifier(str, optional): The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica. Defaults to None.
        tags(List, optional): The tags to assign to the new DB cluster. Defaults to None.
        storage_encrypted(bool, optional): Specifies whether the DB cluster is encrypted. Defaults to None.
        kms_key_id(str, optional): The Amazon KMS key identifier for an encrypted DB cluster. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key. If an encryption key is not specified in KmsKeyId:   If ReplicationSourceIdentifier identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.   If the StorageEncrypted parameter is true and ReplicationSourceIdentifier is not specified, then Amazon Neptune will use your default encryption key.   Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region. If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set KmsKeyId to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region. Defaults to None.
        pre_signed_url(str, optional): This parameter is not currently supported. Defaults to None.
        enable_iam_database_authentication(bool, optional): If set to true, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level). Default: false. Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of log types that need to be enabled for exporting to CloudWatch Logs. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled. Defaults to None.
        source_region(str, optional): The ID of the region that contains the source for the db cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.create(
                ctx, db_cluster_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.create db_cluster_identifier=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="create_db_cluster",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "BackupRetentionPeriod": backup_retention_period,
            "CharacterSetName": character_set_name,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "DatabaseName": database_name,
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "DBSubnetGroupName": db_subnet_group_name,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "OptionGroupName": option_group_name,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "ReplicationSourceIdentifier": replication_source_identifier,
            "Tags": tags,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "PreSignedUrl": pre_signed_url,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DeletionProtection": deletion_protection,
            "SourceRegion": source_region,
        },
    )


async def delete(
    hub,
    ctx,
    db_cluster_identifier: str,
    skip_final_snapshot: bool = None,
    final_db_snapshot_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted. Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set its DeletionProtection field to False.

    Args:
        db_cluster_identifier(str): The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive. Constraints:   Must match an existing DBClusterIdentifier.  .
        skip_final_snapshot(bool, optional):  Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If true is specified, no DB cluster snapshot is created. If false is specified, a DB cluster snapshot is created before the DB cluster is deleted.  You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot is false.  Default: false . Defaults to None.
        final_db_snapshot_identifier(str, optional):  The DB cluster snapshot identifier of the new DB cluster snapshot created when SkipFinalSnapshot is set to false.   Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.  Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.delete(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.delete db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="delete_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "SkipFinalSnapshot": skip_final_snapshot,
            "FinalDBSnapshotIdentifier": final_db_snapshot_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about provisioned DB clusters, and supports pagination.  This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.

    Args:
        db_cluster_identifier(str, optional): The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive. Constraints:   If supplied, must match an existing DBClusterIdentifier.  . Defaults to None.
        filters(List, optional): A filter that specifies one or more DB clusters to describe. Supported filters:    db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.    engine - Accepts an engine name (such as neptune), and restricts the results list to DB clusters created by that engine.   For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB clusters are returned, you could use the following command:. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeDBClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="describe_db_clusters",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def failover(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    target_db_instance_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Forces a failover for a DB cluster. A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer). Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.

    Args:
        db_cluster_identifier(str, optional): A DB cluster identifier to force a failover for. This parameter is not case-sensitive. Constraints:   Must match the identifier of an existing DBCluster.  . Defaults to None.
        target_db_instance_identifier(str, optional): The name of the instance to promote to the primary instance. You must specify the instance identifier for an Read Replica in the DB cluster. For example, mydbcluster-replica1. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.failover(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.failover
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="failover_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "TargetDBInstanceIdentifier": target_db_instance_identifier,
        },
    )


async def modify(
    hub,
    ctx,
    db_cluster_identifier: str,
    new_db_cluster_identifier: str = None,
    apply_immediately: bool = None,
    backup_retention_period: int = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    port: int = None,
    master_user_password: str = None,
    option_group_name: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    enable_iam_database_authentication: bool = None,
    cloudwatch_logs_export_configuration: Dict = None,
    engine_version: str = None,
    deletion_protection: bool = None,
    copy_tags_to_snapshot: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.

    Args:
        db_cluster_identifier(str): The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive. Constraints:   Must match the identifier of an existing DBCluster.  .
        new_db_cluster_identifier(str, optional): The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   The first character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens   Example: my-cluster2 . Defaults to None.
        apply_immediately(bool, optional): A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow setting for the DB cluster. If this parameter is set to false, changes to the DB cluster are applied during the next maintenance window. The ApplyImmediately parameter only affects NewDBClusterIdentifier values. If you set the ApplyImmediately parameter value to false, then changes to NewDBClusterIdentifier values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the ApplyImmediately parameter. Default: false . Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35  . Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to use for the DB cluster. Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups that the DB cluster will belong to. Defaults to None.
        port(int, optional): The port number on which the DB cluster accepts connections. Constraints: Value must be 1150-65535  Default: The same port as the original DB cluster. Defaults to None.
        master_user_password(str, optional): Not supported by Neptune. Defaults to None.
        option_group_name(str, optional):  Not supported by Neptune. . Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled, using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        enable_iam_database_authentication(bool, optional): True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false. Default: false . Defaults to None.
        cloudwatch_logs_export_configuration(Dict, optional): The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. Defaults to None.
        engine_version(str, optional): The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the ApplyImmediately parameter is set to true. For a list of valid engine versions, see Engine Releases for Amazon Neptune, or call DescribeDBEngineVersions. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. Defaults to None.
        copy_tags_to_snapshot(bool, optional):  If set to true, tags are copied to any snapshot of the DB cluster that is created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.modify(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.modify db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="modify_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "NewDBClusterIdentifier": new_db_cluster_identifier,
            "ApplyImmediately": apply_immediately,
            "BackupRetentionPeriod": backup_retention_period,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Port": port,
            "MasterUserPassword": master_user_password,
            "OptionGroupName": option_group_name,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "CloudwatchLogsExportConfiguration": cloudwatch_logs_export_configuration,
            "EngineVersion": engine_version,
            "DeletionProtection": deletion_protection,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
        },
    )


async def start(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts an Amazon Neptune DB cluster that was stopped using the AWS console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the Neptune DB cluster to be started. This parameter is stored as a lowercase string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.start(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.start db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="start_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )


async def stop(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata, including its endpoints and DB parameter groups. Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the Neptune DB cluster to be stopped. This parameter is stored as a lowercase string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.init.stop(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.init.stop db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="stop_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )
