"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_cluster_identifier: str,
    snapshot_identifier: str,
    engine: str,
    availability_zones: List = None,
    engine_version: str = None,
    port: int = None,
    db_subnet_group_name: str = None,
    database_name: str = None,
    option_group_name: str = None,
    vpc_security_group_ids: List = None,
    tags: List = None,
    kms_key_id: str = None,
    enable_iam_database_authentication: bool = None,
    enable_cloudwatch_logs_exports: List = None,
    db_cluster_parameter_group_name: str = None,
    deletion_protection: bool = None,
    copy_tags_to_snapshot: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB cluster from a DB snapshot or DB cluster snapshot. If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group. If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.

    Args:
        availability_zones(List, optional): Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in. Defaults to None.
        db_cluster_identifier(str): The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens   Example: my-snapshot-id .
        snapshot_identifier(str): The identifier for the DB snapshot or DB cluster snapshot to restore from. You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot. Constraints:   Must match the identifier of an existing Snapshot.  .
        engine(str): The database engine to use for the new DB cluster. Default: The same as source Constraint: Must be compatible with the engine of the source.
        engine_version(str, optional): The version of the database engine to use for the new DB cluster. Defaults to None.
        port(int, optional): The port number on which the new DB cluster accepts connections. Constraints: Value must be 1150-65535  Default: The same port as the original DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): The name of the DB subnet group to use for the new DB cluster. Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example: mySubnetgroup . Defaults to None.
        database_name(str, optional): Not supported. Defaults to None.
        option_group_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups that the new DB cluster will belong to. Defaults to None.
        tags(List, optional): The tags to be assigned to the restored DB cluster. Defaults to None.
        kms_key_id(str, optional): The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key. If you do not specify a value for the KmsKeyId parameter, then the following will occur:   If the DB snapshot or DB cluster snapshot in SnapshotIdentifier is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.   If the DB snapshot or DB cluster snapshot in SnapshotIdentifier is not encrypted, then the restored DB cluster is not encrypted.  . Defaults to None.
        enable_iam_database_authentication(bool, optional): True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false. Default: false . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to associate with the new DB cluster. Constraints:   If supplied, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. . Defaults to None.
        copy_tags_to_snapshot(bool, optional):  If set to true, tags are copied to any snapshot of the restored DB cluster that is created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.from_snapshot.restore(
                ctx, db_cluster_identifier=value, snapshot_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.from_snapshot.restore db_cluster_identifier=value, snapshot_identifier=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="restore_db_cluster_from_snapshot",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "DBClusterIdentifier": db_cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "DBSubnetGroupName": db_subnet_group_name,
            "DatabaseName": database_name,
            "OptionGroupName": option_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "DeletionProtection": deletion_protection,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
        },
    )
