"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Create a JWT token to be used to login to Airflow Web UI with claims based Authentication.

    Args:
        name(str): Create an Airflow Web UI login token request for a MWAA environment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.web_login_token.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.web_login_token.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="create_web_login_token",
        op_kwargs={"Name": name},
    )
