"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def publish(hub, ctx, environment_name: str, metric_data: List) -> Dict:
    r"""
    **Autogenerated function**

    An operation for publishing metrics from the customers to the Ops plane.

    Args:
        environment_name(str): Publishes environment metric data to Amazon CloudWatch.
        metric_data(List): Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metrica.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.metric.publish(
                ctx, environment_name=value, metric_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.metric.publish environment_name=value, metric_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="publish_metrics",
        op_kwargs={"EnvironmentName": environment_name, "MetricData": metric_data},
    )
