"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    dag_s3_path: str,
    execution_role_arn: str,
    name: str,
    network_configuration: Dict,
    source_bucket_arn: str,
    airflow_configuration_options: Dict = None,
    airflow_version: str = None,
    environment_class: str = None,
    kms_key: str = None,
    logging_configuration: Dict = None,
    max_workers: int = None,
    min_workers: int = None,
    plugins_s3_object_version: str = None,
    plugins_s3_path: str = None,
    requirements_s3_object_version: str = None,
    requirements_s3_path: str = None,
    schedulers: int = None,
    tags: Dict = None,
    webserver_access_mode: str = None,
    weekly_maintenance_window_start: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.

    Args:
        airflow_configuration_options(Dict, optional): A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see Apache Airflow configuration options. Defaults to None.
        airflow_version(str, optional): The Apache Airflow version for your environment. For example, v1.10.12. If no value is specified, defaults to the latest version. Valid values: v1.10.12. Defaults to None.
        dag_s3_path(str): The relative path to the DAGs folder on your Amazon S3 bucket. For example, dags. To learn more, see Adding or updating DAGs.
        environment_class(str, optional): The environment class type. Valid values: mw1.small, mw1.medium, mw1.large. To learn more, see Amazon MWAA environment class. Defaults to None.
        execution_role_arn(str): The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an AWS Identity and Access Management (IAM) role that grants MWAA permission to access AWS services and resources used by your environment. For example, arn:aws:iam::123456789:role/my-execution-role. To learn more, see Amazon MWAA Execution role.
        kms_key(str, optional): The AWS Key Management Service (KMS) key to encrypt the data in your environment. You can use an AWS owned CMK, or a Customer managed CMK (advanced). To learn more, see Get started with Amazon Managed Workflows for Apache Airflow. Defaults to None.
        logging_configuration(Dict, optional): Defines the Apache Airflow logs to send to CloudWatch Logs: DagProcessingLogs, SchedulerLogs, TaskLogs, WebserverLogs, WorkerLogs. Defaults to None.
        max_workers(int, optional): The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the MaxWorkers field. For example, 20. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in MinWorkers. Defaults to None.
        min_workers(int, optional): The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the MaxWorkers field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the MinWorkers field. For example, 2. Defaults to None.
        name(str): The name of the Amazon MWAA environment. For example, MyMWAAEnvironment.
        network_configuration(Dict): The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see About networking on Amazon MWAA.
        plugins_s3_object_version(str, optional): The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see How S3 Versioning works. Defaults to None.
        plugins_s3_path(str, optional): The relative path to the plugins.zip file on your Amazon S3 bucket. For example, plugins.zip. If specified, then the plugins.zip version is required. To learn more, see Installing custom plugins. Defaults to None.
        requirements_s3_object_version(str, optional): The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see How S3 Versioning works. Defaults to None.
        requirements_s3_path(str, optional): The relative path to the requirements.txt file on your Amazon S3 bucket. For example, requirements.txt. If specified, then a file version is required. To learn more, see Installing Python dependencies. Defaults to None.
        schedulers(int, optional): The number of Apache Airflow schedulers to run in your environment. Defaults to None.
        source_bucket_arn(str): The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, arn:aws:s3:::my-airflow-bucket-unique-name. To learn more, see Create an Amazon S3 bucket for Amazon MWAA.
        tags(Dict, optional): The key-value tag pairs you want to associate to your environment. For example, "Environment": "Staging". To learn more, see Tagging AWS resources. Defaults to None.
        webserver_access_mode(str, optional): The Apache Airflow Web server access mode. To learn more, see Apache Airflow access modes. Defaults to None.
        weekly_maintenance_window_start(str, optional): The day and time of the week to start weekly maintenance updates of your environment in the following format: DAY:HH:MM. For example: TUE:03:30. You can specify a start time in 30 minute increments only. Supported input includes the following:   MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\d|2[0-3]):(00|30)  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.environment.create(
                ctx,
                dag_s3_path=value,
                execution_role_arn=value,
                name=value,
                network_configuration=value,
                source_bucket_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.environment.create dag_s3_path=value, execution_role_arn=value, name=value, network_configuration=value, source_bucket_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="create_environment",
        op_kwargs={
            "AirflowConfigurationOptions": airflow_configuration_options,
            "AirflowVersion": airflow_version,
            "DagS3Path": dag_s3_path,
            "EnvironmentClass": environment_class,
            "ExecutionRoleArn": execution_role_arn,
            "KmsKey": kms_key,
            "LoggingConfiguration": logging_configuration,
            "MaxWorkers": max_workers,
            "MinWorkers": min_workers,
            "Name": name,
            "NetworkConfiguration": network_configuration,
            "PluginsS3ObjectVersion": plugins_s3_object_version,
            "PluginsS3Path": plugins_s3_path,
            "RequirementsS3ObjectVersion": requirements_s3_object_version,
            "RequirementsS3Path": requirements_s3_path,
            "Schedulers": schedulers,
            "SourceBucketArn": source_bucket_arn,
            "Tags": tags,
            "WebserverAccessMode": webserver_access_mode,
            "WeeklyMaintenanceWindowStart": weekly_maintenance_window_start,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.

    Args:
        name(str): The name of the Amazon MWAA environment. For example, MyMWAAEnvironment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.environment.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.environment.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="delete_environment",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of an Amazon Managed Workflows for Apache Airflow (MWAA) environment.

    Args:
        name(str): The name of the Amazon MWAA environment. For example, MyMWAAEnvironment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.environment.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.environment.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mwaa", operation="get_environment", op_kwargs={"Name": name}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.

    Args:
        max_results(int, optional): The maximum number of results to retrieve per page. For example, 5 environments per page. Defaults to None.
        next_token(str, optional): Retrieves the next page of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.environment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.environment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="list_environments",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    airflow_configuration_options: Dict = None,
    airflow_version: str = None,
    dag_s3_path: str = None,
    environment_class: str = None,
    execution_role_arn: str = None,
    logging_configuration: Dict = None,
    max_workers: int = None,
    min_workers: int = None,
    network_configuration: Dict = None,
    plugins_s3_object_version: str = None,
    plugins_s3_path: str = None,
    requirements_s3_object_version: str = None,
    requirements_s3_path: str = None,
    schedulers: int = None,
    source_bucket_arn: str = None,
    webserver_access_mode: str = None,
    weekly_maintenance_window_start: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.

    Args:
        airflow_configuration_options(Dict, optional): A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see Apache Airflow configuration options. Defaults to None.
        airflow_version(str, optional): The Apache Airflow version for your environment. For example, v1.10.12. If no value is specified, defaults to the latest version. Valid values: v1.10.12. Defaults to None.
        dag_s3_path(str, optional): The relative path to the DAGs folder on your Amazon S3 bucket. For example, dags. To learn more, see Adding or updating DAGs. Defaults to None.
        environment_class(str, optional): The environment class type. Valid values: mw1.small, mw1.medium, mw1.large. To learn more, see Amazon MWAA environment class. Defaults to None.
        execution_role_arn(str, optional): The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, arn:aws:iam::123456789:role/my-execution-role. To learn more, see Amazon MWAA Execution role. Defaults to None.
        logging_configuration(Dict, optional): Defines the Apache Airflow logs to send to CloudWatch Logs: DagProcessingLogs, SchedulerLogs, TaskLogs, WebserverLogs, WorkerLogs. Defaults to None.
        max_workers(int, optional): The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the MaxWorkers field. For example, 20. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in MinWorkers. Defaults to None.
        min_workers(int, optional): The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the MaxWorkers field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the MinWorkers field. For example, 2. Defaults to None.
        name(str): The name of your Amazon MWAA environment. For example, MyMWAAEnvironment.
        network_configuration(Dict, optional): The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see About networking on Amazon MWAA. Defaults to None.
        plugins_s3_object_version(str, optional): The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see How S3 Versioning works. Defaults to None.
        plugins_s3_path(str, optional): The relative path to the plugins.zip file on your Amazon S3 bucket. For example, plugins.zip. If specified, then the plugins.zip version is required. To learn more, see Installing custom plugins. Defaults to None.
        requirements_s3_object_version(str, optional): The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see How S3 Versioning works. Defaults to None.
        requirements_s3_path(str, optional): The relative path to the requirements.txt file on your Amazon S3 bucket. For example, requirements.txt. If specified, then a file version is required. To learn more, see Installing Python dependencies. Defaults to None.
        schedulers(int, optional): The number of Apache Airflow schedulers to run in your Amazon MWAA environment. Defaults to None.
        source_bucket_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, arn:aws:s3:::my-airflow-bucket-unique-name. To learn more, see Create an Amazon S3 bucket for Amazon MWAA. Defaults to None.
        webserver_access_mode(str, optional): The Apache Airflow Web server access mode. To learn more, see Apache Airflow access modes. Defaults to None.
        weekly_maintenance_window_start(str, optional): The day and time of the week to start weekly maintenance updates of your environment in the following format: DAY:HH:MM. For example: TUE:03:30. You can specify a start time in 30 minute increments only. Supported input includes the following:   MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\d|2[0-3]):(00|30)  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mwaa.environment.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mwaa.environment.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mwaa",
        operation="update_environment",
        op_kwargs={
            "AirflowConfigurationOptions": airflow_configuration_options,
            "AirflowVersion": airflow_version,
            "DagS3Path": dag_s3_path,
            "EnvironmentClass": environment_class,
            "ExecutionRoleArn": execution_role_arn,
            "LoggingConfiguration": logging_configuration,
            "MaxWorkers": max_workers,
            "MinWorkers": min_workers,
            "Name": name,
            "NetworkConfiguration": network_configuration,
            "PluginsS3ObjectVersion": plugins_s3_object_version,
            "PluginsS3Path": plugins_s3_path,
            "RequirementsS3ObjectVersion": requirements_s3_object_version,
            "RequirementsS3Path": requirements_s3_path,
            "Schedulers": schedulers,
            "SourceBucketArn": source_bucket_arn,
            "WebserverAccessMode": webserver_access_mode,
            "WeeklyMaintenanceWindowStart": weekly_maintenance_window_start,
        },
    )
