"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "with_qualification_type"


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    qualification_type_id: str,
    status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListWorkersWithQualificationType operation returns all of the Workers that have been associated with a given Qualification type.

    Args:
        qualification_type_id(str): The ID of the Qualification type of the Qualifications to return.
        status(str, optional):  The status of the Qualifications to return. Can be Granted | Revoked. . Defaults to None.
        next_token(str, optional): Pagination Token. Defaults to None.
        max_results(int, optional):  Limit the number of results returned. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.worker.with_qualification_type_.list(
                ctx, qualification_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.worker.with_qualification_type.list qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_workers_with_qualification_type",
        op_kwargs={
            "QualificationTypeId": qualification_type_id,
            "Status": status,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
