"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def notify(hub, ctx, subject: str, message_text: str, worker_ids: List) -> Dict:
    r"""
    **Autogenerated function**

     The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously approved or rejected work from the Worker.

    Args:
        subject(str): The subject line of the email message to send. Can include up to 200 characters.
        message_text(str): The text of the email message to send. Can include up to 4,096 characters.
        worker_ids(List): A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.worker.init.notify(
                ctx, subject=value, message_text=value, worker_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.worker.init.notify subject=value, message_text=value, worker_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="notify_workers",
        op_kwargs={
            "Subject": subject,
            "MessageText": message_text,
            "WorkerIds": worker_ids,
        },
    )
