"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, worker_id: str, reason: str) -> Dict:
    r"""
    **Autogenerated function**

    The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs. For example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.

    Args:
        worker_id(str): The ID of the Worker to block.
        reason(str): A message explaining the reason for blocking the Worker. This parameter enables you to keep track of your Workers. The Worker does not see this message.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.worker.block.create(ctx, worker_id=value, reason=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.worker.block.create worker_id=value, reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_worker_block",
        op_kwargs={"WorkerId": worker_id, "Reason": reason},
    )


async def delete(hub, ctx, worker_id: str, reason: str = None) -> Dict:
    r"""
    **Autogenerated function**

    The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs. This operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation. If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If the specified Worker is not blocked, this operation returns successfully.

    Args:
        worker_id(str): The ID of the Worker to unblock.
        reason(str, optional): A message that explains the reason for unblocking the Worker. The Worker does not see this message. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.worker.block.delete(ctx, worker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.worker.block.delete worker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="delete_worker_block",
        op_kwargs={"WorkerId": worker_id, "Reason": reason},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs.

    Args:
        next_token(str, optional): Pagination token. Defaults to None.
        max_results(int, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.worker.block.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.worker.block.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_worker_blocks",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
