"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, notification: Dict, test_event_type: str) -> Dict:
    r"""
    **Autogenerated function**

     The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification. This allows you to test notifications without setting up notifications for a real HIT type and trying to trigger them using the website. When you call this operation, the service attempts to send the test notification immediately.

    Args:
        notification(Dict):  The notification specification to test. This value is identical to the value you would provide to the UpdateNotificationSettings operation when you establish the notification specification for a HIT type. .
        test_event_type(str):  The event to simulate to test the notification specification. This event is included in the test message even if the notification specification does not include the event type. The notification specification does not filter out the test event. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.test_event_notification.send(
                ctx, notification=value, test_event_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.test_event_notification.send notification=value, test_event_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="send_test_event_notification",
        op_kwargs={"Notification": notification, "TestEventType": test_event_type},
    )
