"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    hit_type_id: str = None,
    status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListReviewableHITs operation retrieves the HITs with Status equal to Reviewable or Status equal to Reviewing that belong to the Requester calling the operation.

    Args:
        hit_type_id(str, optional):  The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are considered . Defaults to None.
        status(str, optional):  Can be either Reviewable or Reviewing. Reviewable is the default value. . Defaults to None.
        next_token(str, optional): Pagination Token. Defaults to None.
        max_results(int, optional):  Limit the number of results returned. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.reviewable_hit.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.reviewable_hit.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_reviewable_hits",
        op_kwargs={
            "HITTypeId": hit_type_id,
            "Status": status,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
