"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    hit_id: str,
    policy_levels: List = None,
    retrieve_actions: bool = None,
    retrieve_results: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies for a given HIT. For information about how to specify Review Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return results for both Assignment-level and HIT-level review results.

    Args:
        hit_id(str): The unique identifier of the HIT to retrieve review results for.
        policy_levels(List, optional):  The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies. . Defaults to None.
        retrieve_actions(bool, optional):  Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their outcomes. . Defaults to None.
        retrieve_results(bool, optional):  Specify if the operation should retrieve a list of the results computed by the Review Policies. . Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.
        max_results(int, optional): Limit the number of results returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.review.policy_result_for_hit.list(ctx, hit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.review.policy_result_for_hit.list hit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_review_policy_results_for_hit",
        op_kwargs={
            "HITId": hit_id,
            "PolicyLevels": policy_levels,
            "RetrieveActions": retrieve_actions,
            "RetrieveResults": retrieve_results,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
