"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    qualification_type_id: str,
    worker_id: str,
    integer_value: int = None,
    send_notification: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The AssociateQualificationWithWorker operation gives a Worker a Qualification. AssociateQualificationWithWorker does not require that the Worker submit a Qualification request. It gives the Qualification directly to the Worker.   You can only assign a Qualification of a Qualification type that you created (using the CreateQualificationType operation).    Note: AssociateQualificationWithWorker does not affect any pending Qualification requests for the Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending Qualification request without affecting the Qualification the Worker already has, reject the request with the RejectQualificationRequest operation.

    Args:
        qualification_type_id(str): The ID of the Qualification type to use for the assigned Qualification.
        worker_id(str):  The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT assignments and Qualification requests. .
        integer_value(int, optional): The value of the Qualification to assign. Defaults to None.
        send_notification(bool, optional):  Specifies whether to send a notification email message to the Worker saying that the qualification was assigned to the Worker. Note: this is true by default. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.with_worker.associate(
                ctx, qualification_type_id=value, worker_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.with_worker.associate qualification_type_id=value, worker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="associate_qualification_with_worker",
        op_kwargs={
            "QualificationTypeId": qualification_type_id,
            "WorkerId": worker_id,
            "IntegerValue": integer_value,
            "SendNotification": send_notification,
        },
    )
