"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def create(
    hub,
    ctx,
    name: str,
    description: str,
    qualification_type_status: str,
    keywords: str = None,
    retry_delay_in_seconds: int = None,
    test: str = None,
    answer_key: str = None,
    test_duration_in_seconds: int = None,
    auto_granted: bool = None,
    auto_granted_value: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure.

    Args:
        name(str):  The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.
        keywords(str, optional): One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search. Defaults to None.
        description(str): A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.
        qualification_type_status(str): The initial status of the Qualification type. Constraints: Valid values are: Active | Inactive.
        retry_delay_in_seconds(int, optional): The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request. Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled. Defaults to None.
        test(str, optional):  The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, TestDurationInSeconds must also be specified.  Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true. Constraints: None. If not specified, the Worker may request the Qualification without answering any questions. Defaults to None.
        answer_key(str, optional): The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure. Constraints: Must not be longer than 65535 bytes. Constraints: None. If not specified, you must process Qualification requests manually. Defaults to None.
        test_duration_in_seconds(int, optional): The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification. Defaults to None.
        auto_granted(bool, optional): Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Constraints: If the Test parameter is specified, this parameter cannot be true. Defaults to None.
        auto_granted_value(int, optional): The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.type_.create(
                ctx, name=value, description=value, qualification_type_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.type.create name=value, description=value, qualification_type_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_qualification_type",
        op_kwargs={
            "Name": name,
            "Keywords": keywords,
            "Description": description,
            "QualificationTypeStatus": qualification_type_status,
            "RetryDelayInSeconds": retry_delay_in_seconds,
            "Test": test,
            "AnswerKey": answer_key,
            "TestDurationInSeconds": test_duration_in_seconds,
            "AutoGranted": auto_granted,
            "AutoGrantedValue": auto_granted_value,
        },
    )


async def delete(hub, ctx, qualification_type_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The DeleteQualificationType deletes a Qualification type and deletes any HIT types that are associated with the Qualification type.  This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT types.  DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the Qualification type is available for reuse with CreateQualificationType.

    Args:
        qualification_type_id(str): The ID of the QualificationType to dispose.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.type_.delete(
                ctx, qualification_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.type.delete qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="delete_qualification_type",
        op_kwargs={"QualificationTypeId": qualification_type_id},
    )


async def get(hub, ctx, qualification_type_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The GetQualificationTypeoperation retrieves information about a Qualification type using its ID.

    Args:
        qualification_type_id(str): The ID of the QualificationType.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.type_.get(ctx, qualification_type_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.type.get qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="get_qualification_type",
        op_kwargs={"QualificationTypeId": qualification_type_id},
    )


async def list_all(
    hub,
    ctx,
    must_be_requestable: bool,
    query: str = None,
    must_be_owned_by_caller: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListQualificationTypes operation returns a list of Qualification types, filtered by an optional search term.

    Args:
        query(str, optional):  A text query against all of the searchable attributes of Qualification types. . Defaults to None.
        must_be_requestable(bool): Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test, are returned as results of the search. Some Qualification types, such as those assigned automatically by the system, cannot be requested directly by users. If false, all Qualification types, including those managed by the system, are considered. Valid values are True | False. .
        must_be_owned_by_caller(bool, optional):  Specifies that only Qualification types that the Requester created are returned. If false, the operation returns all Qualification types. . Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return in a single call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.type_.list_all(
                ctx, must_be_requestable=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.type.list_all must_be_requestable=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_qualification_types",
        op_kwargs={
            "Query": query,
            "MustBeRequestable": must_be_requestable,
            "MustBeOwnedByCaller": must_be_owned_by_caller,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    qualification_type_id: str,
    description: str = None,
    qualification_type_status: str = None,
    test: str = None,
    answer_key: str = None,
    test_duration_in_seconds: int = None,
    retry_delay_in_seconds: int = None,
    auto_granted: bool = None,
    auto_granted_value: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its attributes.   Most attributes of a Qualification type can be changed after the type has been created. However, the Name and Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.   You can use this operation to update the test for a Qualification type. The test is updated based on the values specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters. The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key.   If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a test from a Qualification type that has one. If the type already has a test, you cannot update it to be AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will henceforth have a test.   If you want to update the test duration or answer key for an existing test without changing the questions, you must specify a Test parameter with the original questions, along with the updated values.   If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such Qualifications must be granted manually.   You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.

    Args:
        qualification_type_id(str): The ID of the Qualification type to update.
        description(str, optional): The new description of the Qualification type. Defaults to None.
        qualification_type_status(str, optional): The new status of the Qualification type - Active | Inactive. Defaults to None.
        test(str, optional): The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, TestDurationInSeconds must also be specified. Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true. Constraints: None. If not specified, the Worker may request the Qualification without answering any questions. Defaults to None.
        answer_key(str, optional): The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure. Defaults to None.
        test_duration_in_seconds(int, optional): The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification. Defaults to None.
        retry_delay_in_seconds(int, optional): The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified Qualification type before they can retry the Qualification request. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new Qualification type with retries disabled using CreateQualificationType. Defaults to None.
        auto_granted(bool, optional): Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Constraints: If the Test parameter is specified, this parameter cannot be true. Defaults to None.
        auto_granted_value(int, optional): The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.type_.update(
                ctx, qualification_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.type.update qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="update_qualification_type",
        op_kwargs={
            "QualificationTypeId": qualification_type_id,
            "Description": description,
            "QualificationTypeStatus": qualification_type_status,
            "Test": test,
            "AnswerKey": answer_key,
            "TestDurationInSeconds": test_duration_in_seconds,
            "RetryDelayInSeconds": retry_delay_in_seconds,
            "AutoGranted": auto_granted,
            "AutoGrantedValue": auto_granted_value,
        },
    )
