"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, qualification_type_id: str, worker_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type.   To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment data returned by the ListAssignmentsForHIT operation.  Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.

    Args:
        qualification_type_id(str): The ID of the QualificationType.
        worker_id(str): The ID of the Worker whose Qualification is being updated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.score.get(
                ctx, qualification_type_id=value, worker_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.score.get qualification_type_id=value, worker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="get_qualification_score",
        op_kwargs={"QualificationTypeId": qualification_type_id, "WorkerId": worker_id},
    )
