"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(
    hub, ctx, qualification_request_id: str, integer_value: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     The AcceptQualificationRequest operation approves a Worker's request for a Qualification.   Only the owner of the Qualification type can grant a Qualification request for that type.   A successful request for the AcceptQualificationRequest operation returns with no errors and an empty body.

    Args:
        qualification_request_id(str): The ID of the Qualification request, as returned by the GetQualificationRequests operation.
        integer_value(int, optional):  The value of the Qualification. You can omit this value if you are using the presence or absence of the Qualification as the basis for a HIT requirement. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.request.accept(
                ctx, qualification_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.request.accept qualification_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="accept_qualification_request",
        op_kwargs={
            "QualificationRequestId": qualification_request_id,
            "IntegerValue": integer_value,
        },
    )


async def list_all(
    hub,
    ctx,
    qualification_type_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and accepts them using the AcceptQualification operation.

    Args:
        qualification_type_id(str, optional): The ID of the QualificationType. Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Mechanical Turk returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return in a single call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.request.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.request.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_qualification_requests",
        op_kwargs={
            "QualificationTypeId": qualification_type_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def reject(hub, ctx, qualification_request_id: str, reason: str = None) -> Dict:
    r"""
    **Autogenerated function**

     The RejectQualificationRequest operation rejects a user's request for a Qualification.   You can provide a text message explaining why the request was rejected. The Worker who made the request can see this message.

    Args:
        qualification_request_id(str):  The ID of the Qualification request, as returned by the ListQualificationRequests operation. .
        reason(str, optional): A text message explaining why the request was rejected, to be shown to the Worker who made the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.request.reject(
                ctx, qualification_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.request.reject qualification_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="reject_qualification_request",
        op_kwargs={
            "QualificationRequestId": qualification_request_id,
            "Reason": reason,
        },
    )
