"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, worker_id: str, qualification_type_id: str, reason: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user.   You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification can see this message.

    Args:
        worker_id(str): The ID of the Worker who possesses the Qualification to be revoked.
        qualification_type_id(str): The ID of the Qualification type of the Qualification to be revoked.
        reason(str, optional): A text message that explains why the Qualification was revoked. The user who had the Qualification sees this message. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.qualification.from_worker.disassociate(
                ctx, worker_id=value, qualification_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.qualification.from_worker.disassociate worker_id=value, qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="disassociate_qualification_from_worker",
        op_kwargs={
            "WorkerId": worker_id,
            "QualificationTypeId": qualification_type_id,
            "Reason": reason,
        },
    )
