"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update_multiple(
    hub, ctx, hit_type_id: str, notification: Dict = None, active: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

     The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification specification, the operation replaces the old specification with a new one. You can call the UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to modify the notification specification itself by providing updates to the Active status without specifying a new notification specification. To change the Active status of a HIT type's notifications, the HIT type must already have a notification specification, or one must be provided in the same call to UpdateNotificationSettings.

    Args:
        hit_type_id(str):  The ID of the HIT type whose notification specification is being updated. .
        notification(Dict, optional):  The notification specification for the HIT type. . Defaults to None.
        active(bool, optional):  Specifies whether notifications are sent for HITs of this HIT type, according to the notification specification. You must specify either the Notification parameter or the Active parameter for the call to UpdateNotificationSettings to succeed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.notification_setting.update_multiple(
                ctx, hit_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.notification_setting.update_multiple hit_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="update_notification_settings",
        op_kwargs={
            "HITTypeId": hit_type_id,
            "Notification": notification,
            "Active": active,
        },
    )
