"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "for_qualification_type"


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    qualification_type_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListHITsForQualificationType operation returns the HITs that use the given Qualification type for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted with the DeleteHIT operation or that have been auto-deleted.

    Args:
        qualification_type_id(str):  The ID of the Qualification type to use when querying HITs. .
        next_token(str, optional): Pagination Token. Defaults to None.
        max_results(int, optional):  Limit the number of results returned. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hits.for_qualification_type_.list(
                ctx, qualification_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hits.for_qualification_type.list qualification_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_hits_for_qualification_type",
        op_kwargs={
            "QualificationTypeId": qualification_type_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
