"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "with_hit_type"


async def create(
    hub,
    ctx,
    hit_type_id: str,
    lifetime_in_seconds: int,
    max_assignments: int = None,
    question: str = None,
    requester_annotation: str = None,
    unique_request_token: str = None,
    assignment_review_policy: Dict = None,
    hit_review_policy: Dict = None,
    hit_layout_id: str = None,
    hit_layout_parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation.   This is an alternative way to create HITs from the CreateHIT operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.  CreateHITWithHITType also supports several ways to provide question data: by providing a value for the Question parameter that fully specifies the contents of the HIT, or by providing a HitLayoutId and associated HitLayoutParameters.    If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see Amazon Mechanical Turk Pricing.

    Args:
        hit_type_id(str): The HIT type ID you want to create this HIT with.
        max_assignments(int, optional):  The number of times the HIT can be accepted and completed before the HIT becomes unavailable. . Defaults to None.
        lifetime_in_seconds(int):  An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. .
        question(str, optional):  The data the person completing the HIT uses to produce the results.   Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.  Either a Question parameter or a HITLayoutId parameter must be provided. Defaults to None.
        requester_annotation(str, optional):  An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.   The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.   The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. . Defaults to None.
        unique_request_token(str, optional):  A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.    Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.  . Defaults to None.
        assignment_review_policy(Dict, optional):  The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. . Defaults to None.
        hit_review_policy(Dict, optional):  The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. . Defaults to None.
        hit_layout_id(str, optional):  The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.   Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. . Defaults to None.
        hit_layout_parameters(List, optional):  If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.with_hit_type_.create(
                ctx, hit_type_id=value, lifetime_in_seconds=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.with_hit_type.create hit_type_id=value, lifetime_in_seconds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_hit_with_hit_type",
        op_kwargs={
            "HITTypeId": hit_type_id,
            "MaxAssignments": max_assignments,
            "LifetimeInSeconds": lifetime_in_seconds,
            "Question": question,
            "RequesterAnnotation": requester_annotation,
            "UniqueRequestToken": unique_request_token,
            "AssignmentReviewPolicy": assignment_review_policy,
            "HITReviewPolicy": hit_review_policy,
            "HITLayoutId": hit_layout_id,
            "HITLayoutParameters": hit_layout_parameters,
        },
    )
