"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, hit_id: str, hit_type_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT. This operation disassociates the HIT from its old HITType properties and associates it with the new HITType properties. The HIT takes on the properties of the new HITType in place of the old ones.

    Args:
        hit_id(str): The HIT to update.
        hit_type_id(str): The ID of the new HIT type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.type_.of_hit.update(
                ctx, hit_id=value, hit_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.type_.of_hit.update hit_id=value, hit_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="update_hit_type_of_hit",
        op_kwargs={"HITId": hit_id, "HITTypeId": hit_type_id},
    )
