"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    assignment_duration_in_seconds: int,
    reward: str,
    title: str,
    description: str,
    auto_approval_delay_in_seconds: int = None,
    keywords: str = None,
    qualification_requirements: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The CreateHITType operation creates a new HIT type. This operation allows you to define a standard set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing HIT type, the HIT type ID of the existing type will be returned.

    Args:
        auto_approval_delay_in_seconds(int, optional):  The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. . Defaults to None.
        assignment_duration_in_seconds(int):  The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. .
        reward(str):  The amount of money the Requester will pay a Worker for successfully completing the HIT. .
        title(str):  The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. .
        keywords(str, optional):  One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. . Defaults to None.
        description(str):  A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. .
        qualification_requirements(List, optional):  Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the ActionsGuarded field on each QualificationRequirement structure. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.type_.init.create(
                ctx,
                assignment_duration_in_seconds=value,
                reward=value,
                title=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.type_.init.create assignment_duration_in_seconds=value, reward=value, title=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_hit_type",
        op_kwargs={
            "AutoApprovalDelayInSeconds": auto_approval_delay_in_seconds,
            "AssignmentDurationInSeconds": assignment_duration_in_seconds,
            "Reward": reward,
            "Title": title,
            "Keywords": keywords,
            "Description": description,
            "QualificationRequirements": qualification_requirements,
        },
    )
