"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, hit_id: str, revert: bool = None) -> Dict:
    r"""
    **Autogenerated function**

     The UpdateHITReviewStatus operation updates the status of a HIT. If the status is Reviewable, this operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status.

    Args:
        hit_id(str):  The ID of the HIT to update. .
        revert(bool, optional):  Specifies how to update the HIT status. Default is False.     Setting this to false will only transition a HIT from Reviewable to Reviewing     Setting this to true will only transition a HIT from Reviewing to Reviewable   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.review_status.update(ctx, hit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.review_status.update hit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="update_hit_review_status",
        op_kwargs={"HITId": hit_id, "Revert": revert},
    )
