"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    lifetime_in_seconds: int,
    assignment_duration_in_seconds: int,
    reward: str,
    title: str,
    description: str,
    max_assignments: int = None,
    auto_approval_delay_in_seconds: int = None,
    keywords: str = None,
    question: str = None,
    requester_annotation: str = None,
    qualification_requirements: List = None,
    unique_request_token: str = None,
    assignment_review_policy: Dict = None,
    hit_review_policy: Dict = None,
    hit_layout_id: str = None,
    hit_layout_parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The CreateHIT operation creates a new Human Intelligence Task (HIT). The new HIT is made available for Workers to find and accept on the Amazon Mechanical Turk website.   This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its title, reward amount and number of assignments. When you pass these values to CreateHIT, a new HIT is created for you, with a new HITTypeID. The HITTypeID can be used to create additional HITs in the future without needing to specify common parameters such as the title, description and reward amount each time.  An alternative way to create HITs is to first generate a HITTypeID using the CreateHITType operation and then call the CreateHITWithHITType operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.  CreateHIT also supports several ways to provide question data: by providing a value for the Question parameter that fully specifies the contents of the HIT, or by providing a HitLayoutId and associated HitLayoutParameters.    If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see Amazon Mechanical Turk Pricing.

    Args:
        max_assignments(int, optional):  The number of times the HIT can be accepted and completed before the HIT becomes unavailable. . Defaults to None.
        auto_approval_delay_in_seconds(int, optional):  The number of seconds after an assignment for the HIT has been submitted, after which the assignment is considered Approved automatically unless the Requester explicitly rejects it. . Defaults to None.
        lifetime_in_seconds(int):  An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT have been accepted. .
        assignment_duration_in_seconds(int):  The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find and accept. .
        reward(str):  The amount of money the Requester will pay a Worker for successfully completing the HIT. .
        title(str):  The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned. .
        keywords(str, optional):  One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find HITs. . Defaults to None.
        description(str):  A general description of the HIT. A description includes detailed information about the kind of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate the HIT before accepting it. .
        question(str, optional):  The data the person completing the HIT uses to produce the results.   Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.  Either a Question parameter or a HITLayoutId parameter must be provided. Defaults to None.
        requester_annotation(str, optional):  An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application that corresponds with the HIT.   The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown to the Worker, or any other Requester.   The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are grouped. . Defaults to None.
        qualification_requirements(List, optional):  Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the ActionsGuarded field on each QualificationRequirement structure. . Defaults to None.
        unique_request_token(str, optional):  A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.    Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.  . Defaults to None.
        assignment_review_policy(Dict, optional):  The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk to take various actions based on the policy. . Defaults to None.
        hit_review_policy(Dict, optional):  The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based on the policy. . Defaults to None.
        hit_layout_id(str, optional):  The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT by providing those values as HITLayoutParameters.   Constraints: Either a Question parameter or a HITLayoutId parameter must be provided. . Defaults to None.
        hit_layout_parameters(List, optional):  If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter structure. For more information, see HITLayout. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.init.create(
                ctx,
                lifetime_in_seconds=value,
                assignment_duration_in_seconds=value,
                reward=value,
                title=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.init.create lifetime_in_seconds=value, assignment_duration_in_seconds=value, reward=value, title=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_hit",
        op_kwargs={
            "MaxAssignments": max_assignments,
            "AutoApprovalDelayInSeconds": auto_approval_delay_in_seconds,
            "LifetimeInSeconds": lifetime_in_seconds,
            "AssignmentDurationInSeconds": assignment_duration_in_seconds,
            "Reward": reward,
            "Title": title,
            "Keywords": keywords,
            "Description": description,
            "Question": question,
            "RequesterAnnotation": requester_annotation,
            "QualificationRequirements": qualification_requirements,
            "UniqueRequestToken": unique_request_token,
            "AssignmentReviewPolicy": assignment_review_policy,
            "HITReviewPolicy": hit_review_policy,
            "HITLayoutId": hit_layout_id,
            "HITLayoutParameters": hit_layout_parameters,
        },
    )


async def delete(hub, ctx, hit_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The DeleteHIT operation is used to delete HIT that is no longer needed. Only the Requester who created the HIT can delete it.   You can only dispose of HITs that are in the Reviewable state, with all of their submitted assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the Reviewable state (for example, that has not expired, or still has active assignments), or on a HIT that is Reviewable but without all of its submitted assignments already approved or rejected, the service will return an error.      HITs are automatically disposed of after 120 days.     After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.     Disposed HITs are not returned in results for the ListHITs operation.     Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.

    Args:
        hit_id(str): The ID of the HIT to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.init.delete(ctx, hit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.init.delete hit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mturk", operation="delete_hit", op_kwargs={"HITId": hit_id}
    )


async def get(hub, ctx, hit_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The GetHIT operation retrieves the details of the specified HIT.

    Args:
        hit_id(str): The ID of the HIT to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.hit.init.get(ctx, hit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.hit.init.get hit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mturk", operation="get_hit", op_kwargs={"HITId": hit_id}
    )
