"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, assignment_id: str, question_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

     The GetFileUploadURL operation generates and returns a temporary URL. You use the temporary URL to retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure will no longer support the FileUploadAnswer element to be used for the QuestionForm data structure. Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3.

    Args:
        assignment_id(str): The ID of the assignment that contains the question with a FileUploadAnswer.
        question_identifier(str): The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.file_upload_url.get(
                ctx, assignment_id=value, question_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.file_upload_url.get assignment_id=value, question_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="get_file_upload_url",
        op_kwargs={
            "AssignmentId": assignment_id,
            "QuestionIdentifier": question_identifier,
        },
    )
