"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, hit_id: str, expire_at: str) -> Dict:
    r"""
    **Autogenerated function**

     The UpdateExpirationForHIT operation allows you update the expiration time of a HIT. If you update it to a time in the past, the HIT will be immediately expired.

    Args:
        hit_id(str):  The HIT to update. .
        expire_at(str):  The date and time at which you want the HIT to expire .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.expiration_for_hit.update(
                ctx, hit_id=value, expire_at=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.expiration_for_hit.update hit_id=value, expire_at=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="update_expiration_for_hit",
        op_kwargs={"HITId": hit_id, "ExpireAt": expire_at},
    )
