"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    hit_id: str = None,
    assignment_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.

    Args:
        hit_id(str, optional): The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must be specified. Defaults to None.
        assignment_id(str, optional): The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be specified. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.
        max_results(int, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.bonus.payment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.bonus.payment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_bonus_payments",
        op_kwargs={
            "HITId": hit_id,
            "AssignmentId": assignment_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
