"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    worker_id: str,
    bonus_amount: str,
    assignment_id: str,
    reason: str,
    unique_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The SendBonus operation issues a payment of money from your account to a Worker. This payment happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment. Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if your account does not have enough funds to pay for both the bonus and the fees.

    Args:
        worker_id(str): The ID of the Worker being paid the bonus.
        bonus_amount(str):  The Bonus amount is a US Dollar amount specified using a string (for example, "5" represents $5.00 USD and "101.42" represents $101.42 USD). Do not include currency symbols or currency codes. .
        assignment_id(str): The ID of the assignment for which this bonus is paid.
        reason(str): A message that explains the reason for the bonus payment. The Worker receiving the bonus can see this message.
        unique_request_token(str, optional): A unique identifier for this request, which allows you to retry the call on error without granting multiple bonuses. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the bonus already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return an error with a message containing the request ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.bonus.init.send(
                ctx, worker_id=value, bonus_amount=value, assignment_id=value, reason=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.bonus.init.send worker_id=value, bonus_amount=value, assignment_id=value, reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="send_bonus",
        op_kwargs={
            "WorkerId": worker_id,
            "BonusAmount": bonus_amount,
            "AssignmentId": assignment_id,
            "Reason": reason,
            "UniqueRequestToken": unique_request_token,
        },
    )
