"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def approve(
    hub,
    ctx,
    assignment_id: str,
    requester_feedback: str = None,
    override_rejection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ApproveAssignment operation approves the results of a completed assignment.   Approving an assignment initiates two payments from the Requester's Amazon.com account     The Worker who submitted the results is paid the reward specified in the HIT.     Amazon Mechanical Turk fees are debited.     If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns an exception, and the approval is not processed. You can include an optional feedback message with the approval, which the Worker can see in the Status section of the web site.   You can also call this operation for assignments that were previous rejected and approve them by explicitly overriding the previous rejection. This only works on rejected assignments that were submitted within the previous 30 days and only if the assignment's related HIT has not been deleted.

    Args:
        assignment_id(str):  The ID of the assignment. The assignment must correspond to a HIT created by the Requester. .
        requester_feedback(str, optional):  A message for the Worker, which the Worker can see in the Status section of the web site. . Defaults to None.
        override_rejection(bool, optional):  A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to False. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.assignment.init.approve(ctx, assignment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.assignment.init.approve assignment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="approve_assignment",
        op_kwargs={
            "AssignmentId": assignment_id,
            "RequesterFeedback": requester_feedback,
            "OverrideRejection": override_rejection,
        },
    )


async def get(hub, ctx, assignment_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The GetAssignment operation retrieves the details of the specified Assignment.

    Args:
        assignment_id(str): The ID of the Assignment to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.assignment.init.get(ctx, assignment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.assignment.init.get assignment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="get_assignment",
        op_kwargs={"AssignmentId": assignment_id},
    )


async def reject(hub, ctx, assignment_id: str, requester_feedback: str) -> Dict:
    r"""
    **Autogenerated function**

     The RejectAssignment operation rejects the results of a completed assignment.   You can include an optional feedback message with the rejection, which the Worker can see in the Status section of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the assignment was rejected, and can improve the quality of the results the Worker submits in the future.   Only the Requester who created the HIT can reject an assignment for the HIT.

    Args:
        assignment_id(str):  The ID of the assignment. The assignment must correspond to a HIT created by the Requester. .
        requester_feedback(str):  A message for the Worker, which the Worker can see in the Status section of the web site. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.assignment.init.reject(
                ctx, assignment_id=value, requester_feedback=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.assignment.init.reject assignment_id=value, requester_feedback=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="reject_assignment",
        op_kwargs={
            "AssignmentId": assignment_id,
            "RequesterFeedback": requester_feedback,
        },
    )
