"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    hit_id: str,
    next_token: str = None,
    max_results: int = None,
    assignment_statuses: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListAssignmentsForHIT operation retrieves completed assignments for a HIT. You can use this operation to retrieve the results for a HIT.   You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial results with this operation.   Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments that have already been approved and rejected together in one result set.   Only the Requester who created the HIT can retrieve the assignments for that HIT.   Results are sorted and divided into numbered pages and the operation returns a single page of results. You can use the parameters of the operation to control sorting and pagination.

    Args:
        hit_id(str): The ID of the HIT.
        next_token(str, optional): Pagination token. Defaults to None.
        max_results(int, optional): . Defaults to None.
        assignment_statuses(List, optional): The status of the assignments to return: Submitted | Approved | Rejected. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.assignment.for_hit.list(ctx, hit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.assignment.for_hit.list hit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="list_assignments_for_hit",
        op_kwargs={
            "HITId": hit_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "AssignmentStatuses": assignment_statuses,
        },
    )
