"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    hit_id: str,
    number_of_additional_assignments: int,
    unique_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT.   To extend the maximum number of assignments, specify the number of additional assignments.    HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10 or more assignments will result in an AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease exception.   HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created before July 22, 2015 will result in an AWS.MechanicalTurk.HITTooOldForExtension exception.

    Args:
        hit_id(str): The ID of the HIT to extend.
        number_of_additional_assignments(int): The number of additional assignments to request for this HIT.
        unique_request_token(str, optional):  A unique identifier for this request, which allows you to retry the call on error without extending the HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the server. If the extend HIT already exists in the system from a previous call using the same UniqueRequestToken, subsequent calls will return an error with a message containing the request ID. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mturk.additional_assignment_for_hit.create(
                ctx, hit_id=value, number_of_additional_assignments=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mturk.additional_assignment_for_hit.create hit_id=value, number_of_additional_assignments=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mturk",
        operation="create_additional_assignments_for_hit",
        op_kwargs={
            "HITId": hit_id,
            "NumberOfAdditionalAssignments": number_of_additional_assignments,
            "UniqueRequestToken": unique_request_token,
        },
    )
