"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    broker_id: str,
    password: str,
    username: str,
    console_access: bool = None,
    groups: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an ActiveMQ user.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        console_access(bool, optional): Enables access to the ActiveMQ Web Console for the ActiveMQ user. Defaults to None.
        groups(List, optional): The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Defaults to None.
        password(str): Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
        username(str): The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.user.create(
                ctx, broker_id=value, password=value, username=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.user.create broker_id=value, password=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="create_user",
        op_kwargs={
            "BrokerId": broker_id,
            "ConsoleAccess": console_access,
            "Groups": groups,
            "Password": password,
            "Username": username,
        },
    )


async def delete(hub, ctx, broker_id: str, username: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an ActiveMQ user.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        username(str): The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.user.delete(ctx, broker_id=value, username=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.user.delete broker_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="delete_user",
        op_kwargs={"BrokerId": broker_id, "Username": username},
    )


async def describe(hub, ctx, broker_id: str, username: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an ActiveMQ user.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        username(str): The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.user.describe(ctx, broker_id=value, username=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.user.describe broker_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="describe_user",
        op_kwargs={"BrokerId": broker_id, "Username": username},
    )


async def list_all(
    hub, ctx, broker_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all ActiveMQ users.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        max_results(int, optional): The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100. Defaults to None.
        next_token(str, optional): The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.user.list_all(ctx, broker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.user.list_all broker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="list_users",
        op_kwargs={
            "BrokerId": broker_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    broker_id: str,
    username: str,
    console_access: bool = None,
    groups: List = None,
    password: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the information for an ActiveMQ user.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        console_access(bool, optional): Enables access to the the ActiveMQ Web Console for the ActiveMQ user. Defaults to None.
        groups(List, optional): The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Defaults to None.
        password(str, optional): The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=). Defaults to None.
        username(str): The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.user.update(ctx, broker_id=value, username=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.user.update broker_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="update_user",
        op_kwargs={
            "BrokerId": broker_id,
            "ConsoleAccess": console_access,
            "Groups": groups,
            "Password": password,
            "Username": username,
        },
    )
