"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def create(hub, ctx, resource_arn: str, tags: Dict = None) -> None:
    r"""
    **Autogenerated function**

    Add a tag to a resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource tag.
        tags(Dict, optional): The key-value pair for the resource tag. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.tags.create(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.tags.create resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="create_tags",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def delete(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes a tag from a resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource tag.
        tag_keys(List): An array of tag keys to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.tags.delete(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.tags.delete resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="delete_tags",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )


async def list_(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists tags for a resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource tag.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.tags.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.tags.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="list_tags",
        op_kwargs={"ResourceArn": resource_arn},
    )
