"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, configuration_id: str, configuration_revision: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the specified configuration revision for the specified configuration.

    Args:
        configuration_id(str): The unique ID that Amazon MQ generates for the configuration.
        configuration_revision(str): The revision of the configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.configuration.revision.describe(
                ctx, configuration_id=value, configuration_revision=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.configuration.revision.describe configuration_id=value, configuration_revision=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="describe_configuration_revision",
        op_kwargs={
            "ConfigurationId": configuration_id,
            "ConfigurationRevision": configuration_revision,
        },
    )


async def list_all(
    hub, ctx, configuration_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all revisions for the specified configuration.

    Args:
        configuration_id(str): The unique ID that Amazon MQ generates for the configuration.
        max_results(int, optional): The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100. Defaults to None.
        next_token(str, optional): The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.configuration.revision.list_all(ctx, configuration_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.configuration.revision.list_all configuration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="list_configuration_revisions",
        op_kwargs={
            "ConfigurationId": configuration_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
