"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    auto_minor_version_upgrade: bool,
    broker_name: str,
    deployment_mode: str,
    engine_type: str,
    engine_version: str,
    host_instance_type: str,
    publicly_accessible: bool,
    users: List,
    authentication_strategy: str = None,
    configuration: Dict = None,
    creator_request_id: str = None,
    encryption_options: Dict = None,
    ldap_server_metadata: Dict = None,
    logs: Dict = None,
    maintenance_window_start_time: Dict = None,
    security_groups: List = None,
    storage_type: str = None,
    subnet_ids: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a broker. Note: This API is asynchronous. To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy. ec2:CreateNetworkInterface This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account. ec2:CreateNetworkInterfacePermission This permission is required to attach the ENI to the broker instance. ec2:DeleteNetworkInterface ec2:DeleteNetworkInterfacePermission ec2:DetachNetworkInterface ec2:DescribeInternetGateways ec2:DescribeNetworkInterfaces ec2:DescribeNetworkInterfacePermissions ec2:DescribeRouteTables ec2:DescribeSecurityGroups ec2:DescribeSubnets ec2:DescribeVpcs For more information, see Create an IAM User and Get Your AWS Credentials and Never Modify or Delete the Amazon MQ Elastic Network Interface in the Amazon MQ Developer Guide.

    Args:
        authentication_strategy(str, optional): Optional. The authentication strategy used to secure the broker. The default is SIMPLE. Defaults to None.
        auto_minor_version_upgrade(bool): Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.
        broker_name(str): Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
        configuration(Dict, optional): A list of information about the configuration. Defaults to None.
        creator_request_id(str, optional): The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency. Defaults to None.
        deployment_mode(str): Required. The broker's deployment mode.
        encryption_options(Dict, optional): Encryption options for the broker. Does not apply to RabbitMQ brokers. Defaults to None.
        engine_type(str): Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
        engine_version(str): Required. The broker engine's version. For a list of supported engine versions, see Supported engines.
        host_instance_type(str): Required. The broker's instance type.
        ldap_server_metadata(Dict, optional): Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers. Defaults to None.
        logs(Dict, optional): Enables Amazon CloudWatch logging for brokers. Defaults to None.
        maintenance_window_start_time(Dict, optional): The parameters that determine the WeeklyStartTime. Defaults to None.
        publicly_accessible(bool): Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.
        security_groups(List, optional): The list of rules (1 minimum, 125 maximum) that authorize connections to brokers. Defaults to None.
        storage_type(str, optional): The broker's storage type. Defaults to None.
        subnet_ids(List, optional): The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet. If you specify subnets in a shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account. Defaults to None.
        tags(Dict, optional): Create tags when creating the broker. Defaults to None.
        users(List): Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Amazon MQ for RabbitMQ When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.create(
                ctx,
                auto_minor_version_upgrade=value,
                broker_name=value,
                deployment_mode=value,
                engine_type=value,
                engine_version=value,
                host_instance_type=value,
                publicly_accessible=value,
                users=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.create auto_minor_version_upgrade=value, broker_name=value, deployment_mode=value, engine_type=value, engine_version=value, host_instance_type=value, publicly_accessible=value, users=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="create_broker",
        op_kwargs={
            "AuthenticationStrategy": authentication_strategy,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "BrokerName": broker_name,
            "Configuration": configuration,
            "CreatorRequestId": creator_request_id,
            "DeploymentMode": deployment_mode,
            "EncryptionOptions": encryption_options,
            "EngineType": engine_type,
            "EngineVersion": engine_version,
            "HostInstanceType": host_instance_type,
            "LdapServerMetadata": ldap_server_metadata,
            "Logs": logs,
            "MaintenanceWindowStartTime": maintenance_window_start_time,
            "PubliclyAccessible": publicly_accessible,
            "SecurityGroups": security_groups,
            "StorageType": storage_type,
            "SubnetIds": subnet_ids,
            "Tags": tags,
            "Users": users,
        },
    )


async def delete(hub, ctx, broker_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a broker. Note: This API is asynchronous.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.delete(ctx, broker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.delete broker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="delete_broker",
        op_kwargs={"BrokerId": broker_id},
    )


async def describe(hub, ctx, broker_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified broker.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.describe(ctx, broker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.describe broker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="describe_broker",
        op_kwargs={"BrokerId": broker_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all brokers.

    Args:
        max_results(int, optional): The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100. Defaults to None.
        next_token(str, optional): The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="list_brokers",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def reboot(hub, ctx, broker_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Reboots a broker. Note: This API is asynchronous.

    Args:
        broker_id(str): The unique ID that Amazon MQ generates for the broker.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.reboot(ctx, broker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.reboot broker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="reboot_broker",
        op_kwargs={"BrokerId": broker_id},
    )


async def update(
    hub,
    ctx,
    broker_id: str,
    authentication_strategy: str = None,
    auto_minor_version_upgrade: bool = None,
    configuration: Dict = None,
    engine_version: str = None,
    host_instance_type: str = None,
    ldap_server_metadata: Dict = None,
    logs: Dict = None,
    maintenance_window_start_time: Dict = None,
    security_groups: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a pending configuration change to a broker.

    Args:
        authentication_strategy(str, optional): Optional. The authentication strategy used to secure the broker. The default is SIMPLE. Defaults to None.
        auto_minor_version_upgrade(bool, optional): Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Defaults to None.
        broker_id(str): The unique ID that Amazon MQ generates for the broker.
        configuration(Dict, optional): A list of information about the configuration. Defaults to None.
        engine_version(str, optional): The broker engine version. For a list of supported engine versions, see Supported engines. Defaults to None.
        host_instance_type(str, optional): The broker's host instance type to upgrade to. For a list of supported instance types, see Broker instance types. Defaults to None.
        ldap_server_metadata(Dict, optional): Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers. Defaults to None.
        logs(Dict, optional): Enables Amazon CloudWatch logging for brokers. Defaults to None.
        maintenance_window_start_time(Dict, optional): The parameters that determine the WeeklyStartTime. Defaults to None.
        security_groups(List, optional): The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mq.broker.init.update(ctx, broker_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mq.broker.init.update broker_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mq",
        operation="update_broker",
        op_kwargs={
            "AuthenticationStrategy": authentication_strategy,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "BrokerId": broker_id,
            "Configuration": configuration,
            "EngineVersion": engine_version,
            "HostInstanceType": host_instance_type,
            "LdapServerMetadata": ldap_server_metadata,
            "Logs": logs,
            "MaintenanceWindowStartTime": maintenance_window_start_time,
            "SecurityGroups": security_groups,
        },
    )
