"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str = None,
    region: str = None,
    contents: bytes = None,
    snapshot_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates an AWS Mobile Hub project.

    Args:
        name(str, optional):  Name of the project. . Defaults to None.
        region(str, optional):  Default region where project resources should be created. . Defaults to None.
        contents(bytes, optional):  ZIP or YAML file which contains configuration settings to be used when creating the project. This may be the contents of the file downloaded from the URL provided in an export project operation. . Defaults to None.
        snapshot_id(str, optional):  Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included in the share URL when a project is exported. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="create_project",
        op_kwargs={
            "name": name,
            "region": region,
            "contents": contents,
            "snapshotId": snapshot_id,
        },
    )


async def delete(hub, ctx, project_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Delets a project in AWS Mobile Hub.

    Args:
        project_id(str):  Unique project identifier. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.delete(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.delete project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="delete_project",
        op_kwargs={"projectId": project_id},
    )


async def describe(hub, ctx, project_id: str, sync_from_resources: bool = None) -> Dict:
    r"""
    **Autogenerated function**

     Gets details about a project in AWS Mobile Hub.

    Args:
        project_id(str):  Unique project identifier. .
        sync_from_resources(bool, optional):  If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.describe(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.describe project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="describe_project",
        op_kwargs={"projectId": project_id, "syncFromResources": sync_from_resources},
    )


async def export(hub, ctx, project_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS account.

    Args:
        project_id(str):  Unique project identifier. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.export(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.export project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="export_project",
        op_kwargs={"projectId": project_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Lists projects in AWS Mobile Hub.

    Args:
        max_results(int, optional):  Maximum number of records to list in a single response. . Defaults to None.
        next_token(str, optional):  Pagination token. Set to null to start listing projects from start. If non-null pagination token is returned in a result, then pass its value in here in another request to list more projects. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="list_projects",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(hub, ctx, project_id: str, contents: bytes = None) -> Dict:
    r"""
    **Autogenerated function**

     Update an existing project.

    Args:
        contents(bytes, optional):  ZIP or YAML file which contains project configuration to be updated. This should be the contents of the file downloaded from the URL provided in an export project operation. . Defaults to None.
        project_id(str):  Unique project identifier. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.project.update(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.project.update project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="update_project",
        op_kwargs={"contents": contents, "projectId": project_id},
    )
