"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, bundle_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Get the bundle details for the requested bundle id.

    Args:
        bundle_id(str):  Unique bundle identifier. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.bundle.describe(ctx, bundle_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.bundle.describe bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="describe_bundle",
        op_kwargs={"bundleId": bundle_id},
    )


async def export(
    hub, ctx, bundle_id: str, project_id: str = None, platform: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile app clients with backend AWS resources.

    Args:
        bundle_id(str):  Unique bundle identifier. .
        project_id(str, optional):  Unique project identifier. . Defaults to None.
        platform(str, optional):  Developer desktop or target application platform. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.bundle.export(ctx, bundle_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.bundle.export bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="export_bundle",
        op_kwargs={
            "bundleId": bundle_id,
            "projectId": project_id,
            "platform": platform,
        },
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

     List all available bundles.

    Args:
        max_results(int, optional):  Maximum number of records to list in a single response. . Defaults to None.
        next_token(str, optional):  Pagination token. Set to null to start listing bundles from start. If non-null pagination token is returned in a result, then pass its value in here in another request to list more bundles. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mobile.bundle.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mobile.bundle.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mobile",
        operation="list_bundles",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
