"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, home_region: str, target: Dict, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    This API sets up the home region for the calling account only.

    Args:
        home_region(str): The name of the home region of the calling account.
        target(Dict): The account for which this command sets up a home region control. The Target is always of type ACCOUNT.
        dry_run(bool, optional): Optional Boolean flag to indicate whether any effect should take place. It tests whether the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.migrationhub_config_home_region.control.create(
                ctx, home_region=value, target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.migrationhub_config_home_region.control.create home_region=value, target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="migrationhub-config",
        operation="create_home_region_control",
        op_kwargs={"HomeRegion": home_region, "Target": target, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    control_id: str = None,
    home_region: str = None,
    target: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API permits filtering on the ControlId and HomeRegion fields.

    Args:
        control_id(str, optional): The ControlID is a unique identifier string of your HomeRegionControl object. Defaults to None.
        home_region(str, optional): The name of the home region you'd like to view. Defaults to None.
        target(Dict, optional): The target parameter specifies the identifier to which the home region is applied, which is always of type ACCOUNT. It applies the home region to the current ACCOUNT. Defaults to None.
        max_results(int, optional): The maximum number of filtering results to display per page. . Defaults to None.
        next_token(str, optional): If a NextToken was returned by a previous call, more results are available. To retrieve the next page of results, make the call again using the returned token in NextToken. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.migrationhub_config_home_region.control.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.migrationhub_config_home_region.control.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="migrationhub-config",
        operation="describe_home_region_controls",
        op_kwargs={
            "ControlId": control_id,
            "HomeRegion": home_region,
            "Target": target,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
