"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, source_server_i_ds: List, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Lauches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.

    Args:
        source_server_i_ds(List): Start Test for Source Server IDs.
        tags(Dict, optional): Start Test by Tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.test.start(ctx, source_server_i_ds=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.test.start source_server_i_ds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="start_test",
        op_kwargs={"sourceServerIDs": source_server_i_ds, "tags": tags},
    )
