"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def terminate(hub, ctx, source_server_i_ds: List, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.

    Args:
        source_server_i_ds(List): Terminate Target instance by Source Server IDs.
        tags(Dict, optional): Terminate Target instance by Tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.target_instance.terminate(ctx, source_server_i_ds=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.target_instance.terminate source_server_i_ds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="terminate_target_instances",
        op_kwargs={"sourceServerIDs": source_server_i_ds, "tags": tags},
    )
