"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a single source server by ID.

    Args:
        source_server_id(str): Request to delete Source Server from service by Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.source_server.delete(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.source_server.delete source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="delete_source_server",
        op_kwargs={"sourceServerID": source_server_id},
    )


async def describe_all(
    hub, ctx, filters: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all SourceServers or multiple SourceServers by ID.

    Args:
        filters(Dict): Request to filter Source Servers list.
        max_results(int, optional): Request to filter Source Servers list by maximum results. Defaults to None.
        next_token(str, optional): Request to filter Source Servers list by next token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.source_server.describe_all(ctx, filters=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.source_server.describe_all filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="describe_source_servers",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
