"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def change(hub, ctx, life_cycle: Dict, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)

    Args:
        life_cycle(Dict): The request to change the source server migration lifecycle state.
        source_server_id(str): The request to change the source server migration lifecycle state by source server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.server_life_cycle_state.change(
                ctx, life_cycle=value, source_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.server_life_cycle_state.change life_cycle=value, source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="change_server_life_cycle_state",
        op_kwargs={"lifeCycle": life_cycle, "sourceServerID": source_server_id},
    )
