"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    associate_default_security_group: bool,
    bandwidth_throttling: int,
    create_public_ip: bool,
    data_plane_routing: str,
    default_large_staging_disk_type: str,
    ebs_encryption: str,
    replication_server_instance_type: str,
    replication_servers_security_groups_i_ds: List,
    staging_area_subnet_id: str,
    staging_area_tags: Dict,
    use_dedicated_replication_server: bool,
    ebs_encryption_key_arn: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new ReplicationConfigurationTemplate.

    Args:
        associate_default_security_group(bool): Request to associate the default Application Migration Service Security group with the Replication Settings template.
        bandwidth_throttling(int): Request to configure bandwidth throttling during Replication Settings template creation.
        create_public_ip(bool): Request to create Public IP during Replication Settings template creation.
        data_plane_routing(str): Request to configure data plane routing during Replication Settings template creation.
        default_large_staging_disk_type(str): Request to configure the Staging Disk EBS volume type to "gp2" during Replication Settings template creation.
        ebs_encryption(str): Request to configure EBS enryption during Replication Settings template creation.
        ebs_encryption_key_arn(str, optional): Request to configure an EBS enryption key during Replication Settings template creation. Defaults to None.
        replication_server_instance_type(str): Request to configure the Replication Server instance type during Replication Settings template creation.
        replication_servers_security_groups_i_ds(List): Request to configure the Replication Server Secuirity group ID during Replication Settings template creation.
        staging_area_subnet_id(str): Request to configure the Staging Area subnet ID during Replication Settings template creation.
        staging_area_tags(Dict): Request to configure Staiging Area tags during Replication Settings template creation.
        tags(Dict, optional): Request to configure tags during Replication Settings template creation. Defaults to None.
        use_dedicated_replication_server(bool): Request to use Dedicated Replication Servers during Replication Settings template creation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.template.create(
                ctx,
                associate_default_security_group=value,
                bandwidth_throttling=value,
                create_public_ip=value,
                data_plane_routing=value,
                default_large_staging_disk_type=value,
                ebs_encryption=value,
                replication_server_instance_type=value,
                replication_servers_security_groups_i_ds=value,
                staging_area_subnet_id=value,
                staging_area_tags=value,
                use_dedicated_replication_server=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.template.create associate_default_security_group=value, bandwidth_throttling=value, create_public_ip=value, data_plane_routing=value, default_large_staging_disk_type=value, ebs_encryption=value, replication_server_instance_type=value, replication_servers_security_groups_i_ds=value, staging_area_subnet_id=value, staging_area_tags=value, use_dedicated_replication_server=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="create_replication_configuration_template",
        op_kwargs={
            "associateDefaultSecurityGroup": associate_default_security_group,
            "bandwidthThrottling": bandwidth_throttling,
            "createPublicIP": create_public_ip,
            "dataPlaneRouting": data_plane_routing,
            "defaultLargeStagingDiskType": default_large_staging_disk_type,
            "ebsEncryption": ebs_encryption,
            "ebsEncryptionKeyArn": ebs_encryption_key_arn,
            "replicationServerInstanceType": replication_server_instance_type,
            "replicationServersSecurityGroupsIDs": replication_servers_security_groups_i_ds,
            "stagingAreaSubnetId": staging_area_subnet_id,
            "stagingAreaTags": staging_area_tags,
            "tags": tags,
            "useDedicatedReplicationServer": use_dedicated_replication_server,
        },
    )


async def delete(hub, ctx, replication_configuration_template_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a single Replication Configuration Template by ID

    Args:
        replication_configuration_template_id(str): Request to delete Replication Configuration Template from service by Replication Configuration Template ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.template.delete(
                ctx, replication_configuration_template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.template.delete replication_configuration_template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="delete_replication_configuration_template",
        op_kwargs={
            "replicationConfigurationTemplateID": replication_configuration_template_id
        },
    )


async def describe_all(
    hub,
    ctx,
    replication_configuration_template_i_ds: List,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.

    Args:
        max_results(int, optional): Request to describe Replication Configuration template by max results. Defaults to None.
        next_token(str, optional): Request to describe Replication Configuration template by next token. Defaults to None.
        replication_configuration_template_i_ds(List): Request to describe Replication Configuration template by template IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.template.describe_all(
                ctx, replication_configuration_template_i_ds=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.template.describe_all replication_configuration_template_i_ds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="describe_replication_configuration_templates",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "replicationConfigurationTemplateIDs": replication_configuration_template_i_ds,
        },
    )


async def update(
    hub,
    ctx,
    replication_configuration_template_id: str,
    arn: str = None,
    associate_default_security_group: bool = None,
    bandwidth_throttling: int = None,
    create_public_ip: bool = None,
    data_plane_routing: str = None,
    default_large_staging_disk_type: str = None,
    ebs_encryption: str = None,
    ebs_encryption_key_arn: str = None,
    replication_server_instance_type: str = None,
    replication_servers_security_groups_i_ds: List = None,
    staging_area_subnet_id: str = None,
    staging_area_tags: Dict = None,
    use_dedicated_replication_server: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates multiple ReplicationConfigurationTemplates by ID.

    Args:
        arn(str, optional): Update replication configuration template ARN request. Defaults to None.
        associate_default_security_group(bool, optional): Update replication configuration template associate default Application Migration Service Security group request. Defaults to None.
        bandwidth_throttling(int, optional): Update replication configuration template bandwidth throttling request. Defaults to None.
        create_public_ip(bool, optional): Update replication configuration template create Public IP request. Defaults to None.
        data_plane_routing(str, optional): Update replication configuration template data plane routing request. Defaults to None.
        default_large_staging_disk_type(str, optional): Update replication configuration template use default large Staging Disk type request. Defaults to None.
        ebs_encryption(str, optional): Update replication configuration template EBS encryption request. Defaults to None.
        ebs_encryption_key_arn(str, optional): Update replication configuration template EBS encryption key ARN request. Defaults to None.
        replication_configuration_template_id(str): Update replication configuration template template ID request.
        replication_server_instance_type(str, optional): Update replication configuration template Replication Server instance type request. Defaults to None.
        replication_servers_security_groups_i_ds(List, optional): Update replication configuration template Replication Server Security groups IDs request. Defaults to None.
        staging_area_subnet_id(str, optional): Update replication configuration template Staging Area subnet ID request. Defaults to None.
        staging_area_tags(Dict, optional): Update replication configuration template Staging Area Tags request. Defaults to None.
        use_dedicated_replication_server(bool, optional): Update replication configuration template use dedicated Replication Server request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.template.update(
                ctx, replication_configuration_template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.template.update replication_configuration_template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="update_replication_configuration_template",
        op_kwargs={
            "arn": arn,
            "associateDefaultSecurityGroup": associate_default_security_group,
            "bandwidthThrottling": bandwidth_throttling,
            "createPublicIP": create_public_ip,
            "dataPlaneRouting": data_plane_routing,
            "defaultLargeStagingDiskType": default_large_staging_disk_type,
            "ebsEncryption": ebs_encryption,
            "ebsEncryptionKeyArn": ebs_encryption_key_arn,
            "replicationConfigurationTemplateID": replication_configuration_template_id,
            "replicationServerInstanceType": replication_server_instance_type,
            "replicationServersSecurityGroupsIDs": replication_servers_security_groups_i_ds,
            "stagingAreaSubnetId": staging_area_subnet_id,
            "stagingAreaTags": staging_area_tags,
            "useDedicatedReplicationServer": use_dedicated_replication_server,
        },
    )
