"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists all ReplicationConfigurations, filtered by Source Server ID.

    Args:
        source_server_id(str): Request to get Replication Configuaration by Source Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.init.get(
                ctx, source_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.init.get source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="get_replication_configuration",
        op_kwargs={"sourceServerID": source_server_id},
    )


async def update(
    hub,
    ctx,
    source_server_id: str,
    associate_default_security_group: bool = None,
    bandwidth_throttling: int = None,
    create_public_ip: bool = None,
    data_plane_routing: str = None,
    default_large_staging_disk_type: str = None,
    ebs_encryption: str = None,
    ebs_encryption_key_arn: str = None,
    name: str = None,
    replicated_disks: List = None,
    replication_server_instance_type: str = None,
    replication_servers_security_groups_i_ds: List = None,
    staging_area_subnet_id: str = None,
    staging_area_tags: Dict = None,
    use_dedicated_replication_server: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to update multiple ReplicationConfigurations by Source Server ID.

    Args:
        associate_default_security_group(bool, optional): Update replication configuration associate default Application Migration Service Security group request. Defaults to None.
        bandwidth_throttling(int, optional): Update replication configuration bandwidth throttling request. Defaults to None.
        create_public_ip(bool, optional): Update replication configuration create Public IP request. Defaults to None.
        data_plane_routing(str, optional): Update replication configuration data plane routing request. Defaults to None.
        default_large_staging_disk_type(str, optional): Update replication configuration use default large Staging Disk type request. Defaults to None.
        ebs_encryption(str, optional): Update replication configuration EBS encryption request. Defaults to None.
        ebs_encryption_key_arn(str, optional): Update replication configuration EBS encryption key ARN request. Defaults to None.
        name(str, optional): Update replication configuration name request. Defaults to None.
        replicated_disks(List, optional): Update replication configuration replicated disks request. Defaults to None.
        replication_server_instance_type(str, optional): Update replication configuration Replication Server instance type request. Defaults to None.
        replication_servers_security_groups_i_ds(List, optional): Update replication configuration Replication Server Security Groups IDs request. Defaults to None.
        source_server_id(str): Update replication configuration Source Server ID request.
        staging_area_subnet_id(str, optional): Update replication configuration Staging Area subnet request. Defaults to None.
        staging_area_tags(Dict, optional): Update replication configuration Staging Area Tags request. Defaults to None.
        use_dedicated_replication_server(bool, optional): Update replication configuration use dedicated Replication Server request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.replication_configuration.init.update(
                ctx, source_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.replication_configuration.init.update source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="update_replication_configuration",
        op_kwargs={
            "associateDefaultSecurityGroup": associate_default_security_group,
            "bandwidthThrottling": bandwidth_throttling,
            "createPublicIP": create_public_ip,
            "dataPlaneRouting": data_plane_routing,
            "defaultLargeStagingDiskType": default_large_staging_disk_type,
            "ebsEncryption": ebs_encryption,
            "ebsEncryptionKeyArn": ebs_encryption_key_arn,
            "name": name,
            "replicatedDisks": replicated_disks,
            "replicationServerInstanceType": replication_server_instance_type,
            "replicationServersSecurityGroupsIDs": replication_servers_security_groups_i_ds,
            "sourceServerID": source_server_id,
            "stagingAreaSubnetId": staging_area_subnet_id,
            "stagingAreaTags": staging_area_tags,
            "useDedicatedReplicationServer": use_dedicated_replication_server,
        },
    )
