"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists all LaunchConfigurations available, filtered by Source Server IDs.

    Args:
        source_server_id(str): Request to get Launch Configuration information by Source Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.launch_configuration.get(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.launch_configuration.get source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="get_launch_configuration",
        op_kwargs={"sourceServerID": source_server_id},
    )


async def update(
    hub,
    ctx,
    source_server_id: str,
    copy_private_ip: bool = None,
    copy_tags: bool = None,
    launch_disposition: str = None,
    licensing: Dict = None,
    name: str = None,
    target_instance_type_right_sizing_method: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates multiple LaunchConfigurations by Source Server ID.

    Args:
        copy_private_ip(bool, optional): Update Launch configuration copy Private IP request. Defaults to None.
        copy_tags(bool, optional): Update Launch configuration copy Tags request. Defaults to None.
        launch_disposition(str, optional): Update Launch configuration launch disposition request. Defaults to None.
        licensing(Dict, optional): Update Launch configuration licensing request. Defaults to None.
        name(str, optional): Update Launch configuration name request. Defaults to None.
        source_server_id(str): Update Launch configuration by Source Server ID request.
        target_instance_type_right_sizing_method(str, optional): Update Launch configuration Target instance right sizing request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.launch_configuration.update(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.launch_configuration.update source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="update_launch_configuration",
        op_kwargs={
            "copyPrivateIp": copy_private_ip,
            "copyTags": copy_tags,
            "launchDisposition": launch_disposition,
            "licensing": licensing,
            "name": name,
            "sourceServerID": source_server_id,
            "targetInstanceTypeRightSizingMethod": target_instance_type_right_sizing_method,
        },
    )
