"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, filters: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are normaly created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.

    Args:
        filters(Dict): Request to describe Job log filters.
        max_results(int, optional): Request to describe Job log by max results. Defaults to None.
        next_token(str, optional): Request to describe Job logby next token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.jobs.describe(ctx, filters=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.jobs.describe filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="describe_jobs",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
