"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, job_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves detailed Job log with paging.

    Args:
        job_id(str): Request to describe Job log job ID.
        max_results(int, optional): Request to describe Job log item maximum results. Defaults to None.
        next_token(str, optional): Request to describe Job log next token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.job.log_item.describe_all(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.job.log_item.describe_all job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="describe_job_log_items",
        op_kwargs={"jobID": job_id, "maxResults": max_results, "nextToken": next_token},
    )
