"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a single Job by ID.

    Args:
        job_id(str): Request to delete Job from service by Job ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.job.init.delete(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.job.init.delete job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mgn", operation="delete_job", op_kwargs={"jobID": job_id}
    )
