"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def retry(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Causes the data replication initiation sequence to begin immediately upon next Handshake for specified SourceServer IDs, regardless of when the previous initiation started. This command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.

    Args:
        source_server_id(str): Retry data replication for Source Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.data_replication.retry(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.data_replication.retry source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="retry_data_replication",
        op_kwargs={"sourceServerID": source_server_id},
    )
