"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def finalize(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be to DISCONNECTED; The SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDurationwill be nullified.

    Args:
        source_server_id(str): Request to finalize Cutover by Soure Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.cutover.finalize(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.cutover.finalize source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="finalize_cutover",
        op_kwargs={"sourceServerID": source_server_id},
    )


async def start(hub, ctx, source_server_i_ds: List, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.

    Args:
        source_server_i_ds(List): Start Cutover by Source Server IDs.
        tags(Dict, optional): Start Cutover by Tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.cutover.start(ctx, source_server_i_ds=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.cutover.start source_server_i_ds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="start_cutover",
        op_kwargs={"sourceServerIDs": source_server_i_ds, "tags": tags},
    )
