"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def mark(hub, ctx, source_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified SourceServers by ID. This command only works for SourceServers with a lifecycle.state which equals DISCONNECTED or CUTOVER.

    Args:
        source_server_id(str): Mark as archived by Source Server ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgn.as_archived.mark(ctx, source_server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgn.as_archived.mark source_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgn",
        operation="mark_as_archived",
        op_kwargs={"sourceServerID": source_server_id},
    )
